//****************************************************************************
//
//
//
//****************************************************************************



#ifndef __SIMULATION_H
#define __SIMULATION_H

#define DEFAULT_USE_TOROIDAL_SPACE true

// ===========================================================================
//                                  Libraries
// ===========================================================================
#include <string>
#include <vector>


// ===========================================================================
//                                Project Files
// ===========================================================================
#include "bwindow.h"
#include "Population.h"
#include "Environment.h"


// ===========================================================================
//                              Class declarations
// ===========================================================================

class Simulation
{
  public :
    
    // =======================================================================
    //                                 Enums
    // =======================================================================
    
    // =======================================================================
    //                               Constructors
    // =======================================================================
    Simulation(std::string _n = "DefaultSim");

    // =======================================================================
    //                                Destructor
    // =======================================================================
    virtual ~Simulation( void );

    // =======================================================================
    //                            Accessors: getters
    // =======================================================================
	inline const Environment * GetEnv() const { return env; }

    // =======================================================================
    //                            Accessors: setters
    // =======================================================================

    // =======================================================================
    //                                Operators
    // =======================================================================

    // =======================================================================
    //                              Public Methods
    // =======================================================================
	void Simulate();

    // =======================================================================
    //                             Public Attributes
    // =======================================================================





  protected :

    // =======================================================================
    //                            Forbidden Constructors
    // =======================================================================

    // =======================================================================
    //                              Protected Methods
    // =======================================================================
	void update(double deltaT);
	void draw();

    // =======================================================================
    //                             Protected Attributes
    // =======================================================================
	bwindow *win;
	std::string name;

	Environment *env;
	std::vector<Population *> pops;
};


// ===========================================================================
//                              Getters' definitions
// ===========================================================================

// ===========================================================================
//                              Setters' definitions
// ===========================================================================

// ===========================================================================
//                             Operators' definitions
// ===========================================================================

// ===========================================================================
//                          Inline functions' definition
// ===========================================================================


#endif // __TEMPLATE_CLASS_H__

