//****************************************************************************
//
//
//
//****************************************************************************


 
 
// ===========================================================================
//                                   Libraries
// ===========================================================================
#include <iostream>
#include <sys/timeb.h>


// ===========================================================================
//                                 Project Files
// ===========================================================================
#include "Simulation.h"


//TMP
#include "Alignement.h"
#include "AvoidOthers.h"
#include "ClusterToPop.h"
#include "AvoidBorders.h"
#include "Predator.h"
#include "AvoidPredator.h"
#include "AvoidObstacles.h"


//############################################################################
//                                                                           #
//                           Class Simulation                                #
//                                                                           #
//############################################################################

// ===========================================================================
//                         Definition of static attributes
// ===========================================================================

// ===========================================================================
//                                  Constructors
// ===========================================================================
Simulation::Simulation(std::string _n) : name(_n)
{
	const unsigned int width = 1500;
	const unsigned int height = 900;
	const unsigned int defNbBoids = 150;
	const unsigned int defNbPreds = 10;
	const unsigned int defNbSupPreds = 2;

	win = new bwindow(width, height, name.c_str());

	env = new Environment(this, width, height, DEFAULT_USE_TOROIDAL_SPACE);
	env->GenerateRandomObstacles(10, 10, 0x000000);
	env->GenerateClusteredObstacles(3, 10, 100, 10, 0x000000);
	// TODO TMP
	// Create default population
	pops.push_back(new Population(this, defNbBoids));
	pops.push_back(new Population(this, defNbPreds));
	pops.push_back(new Population(this, defNbSupPreds));

	pops[0]->SetPopColor(0x20D020);
	pops[1]->SetPopColor(0xFFCC00);
	pops[1]->SetPopSize(20);
	pops[2]->SetPopColor(0xD02020);
	pops[2]->SetPopSize(30);

	pops[0]->AddPredatorPop(pops[1]);
	pops[1]->AddPreyPop(pops[0]);

	pops[1]->AddPredatorPop(pops[2]);
	pops[2]->AddPreyPop(pops[1]);

	pops[0]->AddBehavior(new Alignement(15, 50), true);
	pops[0]->AddBehavior(new AvoidOthers(200, 35), true);
	pops[0]->AddBehavior(new AvoidObstacles(300, 35), true);
	pops[0]->AddBehavior(new ClusterToPop(10, 100), true);
	pops[0]->AddBehavior(new AvoidPredator(2000), true);
	if (not env->IsTorSpace())
		pops[0]->AddBehavior(new AvoidBorders(100, 50), true);

	pops[1]->AddBehavior(new Predator(1000, 300, 20, 2.5, 0.5), true);
	pops[1]->AddBehavior(new Alignement(15, 50), true);
	pops[1]->AddBehavior(new AvoidPredator(1000), true);
	pops[1]->AddBehavior(new AvoidObstacles(300, 35), true);
	pops[1]->AddBehavior(new AvoidOthers(200, 35), true);
	if (not env->IsTorSpace())
		pops[1]->AddBehavior(new AvoidBorders(100, 50), true);

	pops[2]->AddBehavior(new Predator(1000, 300, 20, 2.5, 0.5), true);
	pops[2]->AddBehavior(new AvoidObstacles(300, 35), true);
	pops[2]->AddBehavior(new AvoidOthers(200, 35), true);
	if (not env->IsTorSpace())
		pops[2]->AddBehavior(new AvoidBorders(100, 50), true);
}

// ===========================================================================
//                                  Destructor
// ===========================================================================
Simulation::~Simulation( void )
{
	for (unsigned int i = 0 ; i < pops.size() ; ++i)
		delete pops[i];
	delete env;
	delete win;
}

// ===========================================================================
//                                 Public Methods
// ===========================================================================
void Simulation::Simulate()
{
	if (win->init() == 0)
	{
		win->map();
		bool cont = true;
		timeb lastclock;
		ftime(&lastclock);
		timeb newclock;
		double deltaT = 0;
		while (cont)
		{
			ftime(&newclock);
			deltaT = (double)(newclock.time - lastclock.time) +
				((double)(newclock.millitm - lastclock.millitm)) / 1000.0;
			lastclock = newclock;
			update(deltaT);
			draw();

			if(win->parse_event() == BKPRESS)
			{
				std::cout << win->get_lastkey() << std::endl;
				if (std::string(win->get_lastkey()) == "t")
					for (unsigned int i = 0 ; i < pops.size() ; ++i)
						pops[i]->ToggleTrace();
			}

			usleep(10000);
		}
	}
	else
		std::cerr << "Window init failed !" << std::endl;
}

// ===========================================================================
//                                Protected Methods
// ===========================================================================

void Simulation::update(double deltaT)
{
	env->Update(deltaT);
	for (unsigned int i = 0 ; i < pops.size() ; ++i)
		pops[i]->Update(deltaT);
}

void Simulation::draw()
{
	env->Draw(win);
	for (unsigned int i = 0 ; i < pops.size() ; ++i)
		pops[i]->Draw(win);
}

// ===========================================================================
//                               Non inline accessors
// ===========================================================================

