//****************************************************************************
//
//
//
//****************************************************************************


#define DEFAULT_MAX_DIST 99999999
 
// ===========================================================================
//                                   Libraries
// ===========================================================================
#include <stdlib.h>
//TMP
#include <iostream>

// ===========================================================================
//                                 Project Files
// ===========================================================================
#include "Predator.h"
#include "Population.h"
#include "bwindow.h"
#include "Simulation.h"


//############################################################################
//                                                                           #
//                           Class Predator                                  #
//                                                                           #
//############################################################################

// ===========================================================================
//                         Definition of static attributes
// ===========================================================================

// ===========================================================================
//                                  Constructors
// ===========================================================================
Predator::Predator(double _str, double _rad, double _capRad, double _ft, double _dct) : 
	str(_str), radius(_rad), captureRadius(_capRad), freezeTime(_ft), direcChangeTime(_dct)
{
}

// ===========================================================================
//                                  Destructor
// ===========================================================================
Predator::~Predator( void )
{
}

// ===========================================================================
//                                 Public Methods
// ===========================================================================
void Predator::ApplyBehavior(Boid * boid)
{
	static double tmpX;
	static double tmpY;
	static double nbNeighbs;
	static double minDist;
	static double normVal;
	static PointObject tmpVect;

	// TODO Optimize
	tmpX = 0;
	tmpY = 0;
	minDist = DEFAULT_MAX_DIST;
	const std::vector<const Population *> & preys = boid->GetPop()->GetPreys();
	// For each potential neighbor
	for (unsigned int i = 0 ; i < preys.size() ; ++i)
		for (Population::BoidIt it = preys[i]->begin() ; it != preys[i]->end() ; ++it)
			if ((*it)->DistTo(*boid) <= radius and (*it)->DistTo(*boid) < minDist) 
			{
				minDist = (*it)->DistTo(*boid);
				tmpVect = boid->VectTo(**it);
				/*
				tmpX = (*it)->GetX();
				tmpY = (*it)->GetY();
				*/
			}

	if (minDist < DEFAULT_MAX_DIST)
	{
		normVal = tmpVect.GetNorm();
		/*sqrt((tmpX - boid->GetX()) * (tmpX - boid->GetX()) + 
			(tmpY - boid->GetY()) * (tmpY - boid->GetY()));
		tmpX = str * (tmpX - boid->GetX()) / normVal;
		tmpY = str * (tmpY - boid->GetY()) / normVal;
		*/
		tmpX = str * tmpVect.GetX() / normVal;
		tmpY = str * tmpVect.GetY() / normVal;
	}
	else if (boid->GetLastDirecChange() >= direcChangeTime)
	{
		tmpX = str * (2.0 * (double)rand() / RAND_MAX - 1.0);
		tmpY = str * (2.0 * (double)rand() / RAND_MAX - 1.0);
	}

	if (minDist < captureRadius)
		boid->FreezeForTime(freezeTime);
	else
		boid->ApplyForce(tmpX, tmpY);
}

void Predator::Draw(Boid * boid, bwindow *w) const
{
	static int tmpX;
	static int tmpY;
	static double maxX;
	static double maxY;

	maxX = boid->GetPop()->GetSim()->GetEnv()->GetXMax();
	maxY = boid->GetPop()->GetSim()->GetEnv()->GetYMax();
	tmpX = w->get_width() * boid->GetX() / maxX;
	tmpY = w->get_height() * boid->GetY() / maxY;
	w->draw_circle(tmpX, tmpY, 1.5 * boid->GetSize(), 0xFF0000);
}

// ===========================================================================
//                                Protected Methods
// ===========================================================================

// ===========================================================================
//                               Non inline accessors
// ===========================================================================

