//****************************************************************************
//
//
//
//****************************************************************************



#ifndef __POPULATION_H__
#define __POPULATION_H__


#define DEFAULT_POP_NBFIELDPOINTS_X 15
#define DEFAULT_POP_NBFIELDPOINTS_Y 10

// ===========================================================================
//                                  Libraries
// ===========================================================================
#include <vector>

// ===========================================================================
//                                Project Files
// ===========================================================================
#include "Boid.h"
#include "bwindow.h"


// ===========================================================================
//                              Class declarations
// ===========================================================================

// Forward declarations
class Simulation;


class Population
{
  public :
    
    // =======================================================================
    //                                 Enums
    // =======================================================================
	typedef std::vector<Boid *>::const_iterator BoidIt;
    
    // =======================================================================
    //                               Constructors
    // =======================================================================
    Population(Simulation *_s, unsigned int nbBoids);

    // =======================================================================
    //                                Destructor
    // =======================================================================
    virtual ~Population( void );

    // =======================================================================
    //                            Accessors: getters
    // =======================================================================
	inline const Simulation * GetSim() const { return sim; }

	inline BoidIt begin() const { return boids.begin(); }
	inline BoidIt end() const { return boids.end(); }
	inline const std::vector<const Population *> & GetPredators() const 
	{ return predators; }
	inline const std::vector<const Population *> & GetPreys() const 
	{ return preys; }

    // =======================================================================
    //                            Accessors: setters
    // =======================================================================

    // =======================================================================
    //                                Operators
    // =======================================================================

    // =======================================================================
    //                              Public Methods
    // =======================================================================
	virtual void Update(double deltaT);
	virtual void Draw(bwindow *w);
	virtual void AddPredatorPop(const Population * _p);
	virtual void AddPreyPop(const Population * _p);
	virtual void AddBehavior(Behavior *_b, bool free);

	virtual void SetPopColor(unsigned int color);
	virtual void SetPopSize(unsigned int size);

	virtual void ToggleTrace();
	virtual void ToggleShowMeanSpeedField();

    // =======================================================================
    //                             Public Attributes
    // =======================================================================





  protected :
    // =======================================================================
    //                              Protected Methods
    // =======================================================================

    // =======================================================================
    //                             Protected Attributes
    // =======================================================================
	Simulation *sim;

	std::vector<Boid *> boids;

	std::vector<const Population *> predators;
	std::vector<const Population *> preys;

	std::vector<Behavior *> behavsToFree;

	bool showMeanSpeed;
	std::vector<std::vector<std::pair<int, PointObject> > > speedField;
};

#endif // __POPULATION_H__

