//****************************************************************************
//
//
//
//****************************************************************************


 
 
// ===========================================================================
//                                   Libraries
// ===========================================================================

//TEMP
#include <iostream>


// ===========================================================================
//                                 Project Files
// ===========================================================================
#include "Population.h"


//############################################################################
//                                                                           #
//                           Class Population                                #
//                                                                           #
//############################################################################

// ===========================================================================
//                         Definition of static attributes
// ===========================================================================

// ===========================================================================
//                                  Constructors
// ===========================================================================
Population::Population(Simulation *_s, unsigned int nbBoids) : sim(_s), showMeanSpeed(false)
{
	for (unsigned int i = 0 ; i < nbBoids ; ++i)
		boids.push_back(new Boid(this));
}

// ===========================================================================
//                                  Destructor
// ===========================================================================
Population::~Population( void )
{
	for (unsigned int i = 0 ; i < boids.size() ; ++i)
		delete boids[i];
	for (unsigned int i = 0 ; i < behavsToFree.size() ; ++i)
		delete behavsToFree[i];
}

// ===========================================================================
//                                 Public Methods
// ===========================================================================

void Population::Update(double deltaT)
{
	for (unsigned int i = 0 ; i < boids.size() ; ++i)
		boids[i]->Update(deltaT);

	/*
	// Update mean speed field
	if (showMeanSpeed)
		for (unsigned int x = 0 ; x < speedField.size() ; ++x)
			for (unsigned int y = 0 ; y < speedField[x].size() ; ++y)
				for (unsigned int i = 0 ; i < boids.size() ; ++i)
	*/				
}

void Population::Draw(bwindow *w)
{
	// Draw Boids
	for (unsigned int i = 0 ; i < boids.size() ; ++i)
		boids[i]->Draw(w);
}

void Population::AddPredatorPop(const Population * _p)
{
	predators.push_back(_p);
}

void Population::AddPreyPop(const Population * _p)
{
	preys.push_back(_p);
}

void Population::AddBehavior(Behavior *_b, bool free)
{
	for (unsigned int i = 0 ; i < boids.size() ; ++i)
		boids[i]->AddBehavior(_b, false);
	if (free)
		behavsToFree.push_back(_b);
}

void Population::SetPopColor(unsigned int color)
{
	for (unsigned int i = 0 ; i < boids.size() ; ++i)
		boids[i]->SetColor(color);
}

void Population::SetPopSize(unsigned int size)
{
	for (unsigned int i = 0 ; i < boids.size() ; ++i)
		boids[i]->SetSize(size);
}

void Population::ToggleTrace()
{
	for (unsigned int i = 0 ; i < boids.size() ; ++i)
		boids[i]->ToggleTrace();
}

void Population::ToggleShowMeanSpeedField()
{
	showMeanSpeed = not showMeanSpeed;
	if (showMeanSpeed)
		speedField = std::vector<std::vector<std::pair<int, PointObject> > >(
			DEFAULT_POP_NBFIELDPOINTS_X, std::vector<std::pair<int, PointObject> >(
			DEFAULT_POP_NBFIELDPOINTS_Y, std::make_pair(1, PointObject(0, 0))));
	else
		speedField.clear();
}

// ===========================================================================
//                                Protected Methods
// ===========================================================================

// ===========================================================================
//                               Non inline accessors
// ===========================================================================

