//****************************************************************************
//
//
//
//****************************************************************************



#ifndef __POINTOBJECT_H__
#define __POINTOBJECT_H__


// ===========================================================================
//                                  Libraries
// ===========================================================================


// ===========================================================================
//                                Project Files
// ===========================================================================




// ===========================================================================
//                              Class declarations
// ===========================================================================


// Forward Declarations
class Environment;


class PointObject
{
  public :
  	friend class MovingObject;
    
    // =======================================================================
    //                                 Enums
    // =======================================================================
    
    // =======================================================================
    //                               Constructors
    // =======================================================================
    PointObject(double _x = 0, double _y = 0, const Environment * e = 0);

    // =======================================================================
    //                                Destructor
    // =======================================================================
    virtual ~PointObject( void );

    // =======================================================================
    //                            Accessors: getters
    // =======================================================================
	inline double GetX() const { return x; }
	inline double GetY() const { return y; }
	inline const Environment * GetEmbedSpace() const { return embedSpace; }

    // =======================================================================
    //                            Accessors: setters
    // =======================================================================

    // =======================================================================
    //                                Operators
    // =======================================================================

    // =======================================================================
    //                              Public Methods
    // =======================================================================
	virtual double DistTo(const PointObject & o) const;
	virtual PointObject VectTo(const PointObject & o) const;
	virtual double GetNorm() const;

    // =======================================================================
    //                             Public Attributes
    // =======================================================================





  protected :
    // =======================================================================
    //                              Protected Methods
    // =======================================================================

    // =======================================================================
    //                             Protected Attributes
    // =======================================================================
	double x;
	double y;

	const Environment * embedSpace;
};

#endif // __POINTOBJECT_H__

