//****************************************************************************
//
//
//
//****************************************************************************


 
 
// ===========================================================================
//                                   Libraries
// ===========================================================================
#include <math.h>
#include <algorithm>


// ===========================================================================
//                                 Project Files
// ===========================================================================
#include "PointObject.h"
#include "Environment.h"



//############################################################################
//                                                                           #
//                           Class PointObject                               #
//                                                                           #
//############################################################################

// ===========================================================================
//                         Definition of static attributes
// ===========================================================================

// ===========================================================================
//                                  Constructors
// ===========================================================================
PointObject::PointObject(double _x, double _y, const Environment * e) : 
	x(_x), y(_y), embedSpace(e)
{
}

// ===========================================================================
//                                  Destructor
// ===========================================================================
PointObject::~PointObject( void )
{
}

// ===========================================================================
//                                 Public Methods
// ===========================================================================
double PointObject::DistTo(const PointObject & o) const
{
	static double tmpX;
	static double tmpY;
	if (embedSpace and embedSpace->IsTorSpace())
	{
		tmpX = std::min(fabs(x - o.x), 
			fabs(embedSpace->GetXMax() - std::max(x, o.x) + std::min(x, o.x)));
		tmpY = std::min(fabs(y - o.y), 
			fabs(embedSpace->GetYMax() - std::max(y, o.y) + std::min(y, o.y)));
		return sqrt(tmpX * tmpX + tmpY * tmpY);
	}
	else
		return sqrt((x - o.x)*(x - o.x) + (y - o.y)*(y - o.y));
}

PointObject PointObject::VectTo(const PointObject & o) const
{
	static double tmpX;
	static double tmpY;
	if (embedSpace and embedSpace->IsTorSpace())
	{
		if (fabs(o.x - x) <= fabs(embedSpace->GetXMax() - std::max(x, o.x) + std::min(x, o.x)))
			tmpX = o.x - x;
		else
			tmpX = o.x - x + ((x > o.x) ? 1.0 : -1.0) * embedSpace->GetXMax();

		if (fabs(o.y - y) <= fabs(embedSpace->GetYMax() - std::max(y, o.y) + std::min(y, o.y)))
			tmpY = o.y - y;
		else
			tmpY = o.y - y + ((y > o.y) ? 1.0 : -1.0) * embedSpace->GetYMax();

		return PointObject(tmpX, tmpY, embedSpace);
	}
	else
		return PointObject(o.x - x, o.y - y, embedSpace);
}

double PointObject::GetNorm() const
{
	return sqrt(x*x + y*y);
}

// ===========================================================================
//                                Protected Methods
// ===========================================================================

// ===========================================================================
//                               Non inline accessors
// ===========================================================================

