//****************************************************************************
//
//
//
//****************************************************************************


 
 
// ===========================================================================
//                                   Libraries
// ===========================================================================
#include <algorithm>


// ===========================================================================
//                                 Project Files
// ===========================================================================
#include "Obstacle.h"
#include "bwindow.h"
#include "Environment.h"


//############################################################################
//                                                                           #
//                           Class Obstacle                                  #
//                                                                           #
//############################################################################

// ===========================================================================
//                         Definition of static attributes
// ===========================================================================

// ===========================================================================
//                                  Constructors
// ===========================================================================
Obstacle::Obstacle(double _x, double _y, Environment * _env, double _oSize, 
	unsigned int _oC) : 
	PointObject(_x, _y, _env), oSize(_oSize), oColor(_oC)
{
}

// ===========================================================================
//                                  Destructor
// ===========================================================================
Obstacle::~Obstacle( void )
{
}

// ===========================================================================
//                                 Public Methods
// ===========================================================================
void Obstacle::Draw(bwindow *w)
{
	static int tmpX;
	static int tmpY;
	static double maxX;
	static double maxY;
	static int sizeX;
	static int sizeY;

	maxX = embedSpace->GetXMax();
	maxY = embedSpace->GetYMax();

	tmpX = w->get_width() * x / maxX;
	tmpY = w->get_height() * y / maxY;
	sizeX = w->get_width() * oSize / maxX;
	sizeY = w->get_height() * oSize / maxY;

	//std::cout << x << " // " << y << std::endl;
	//std::cout << tmpX << " // " << tmpY << std::endl;

	w->draw_fsquare(std::max(0, tmpX - sizeX / 2), std::max(0, tmpY - sizeY / 2),
				   std::min((int)w->get_width(), tmpX + sizeX / 2), std::min((int)w->get_height(),
				   tmpY + sizeY / 2), oColor);

}

// ===========================================================================
//                                Protected Methods
// ===========================================================================

// ===========================================================================
//                               Non inline accessors
// ===========================================================================

