//****************************************************************************
//
//
//
//****************************************************************************



#ifndef __MOVINGOBJECT_H__
#define __MOVINGOBJECT_H__


// ===========================================================================
//                                  Libraries
// ===========================================================================
#include <math.h>


// ===========================================================================
//                                Project Files
// ===========================================================================
#include "PointObject.h"



// ===========================================================================
//                              Class declarations
// ===========================================================================

// Forward Declarations
class Environment;


class MovingObject : public PointObject
{
  public :
    
    // =======================================================================
    //                                 Enums
    // =======================================================================
    
    // =======================================================================
    //                               Constructors
    // =======================================================================
    MovingObject(double _x, double _y, const Environment * e, double _xs = 0, double _ys = 0);

    // =======================================================================
    //                                Destructor
    // =======================================================================
    virtual ~MovingObject( void );

    // =======================================================================
    //                            Accessors: getters
    // =======================================================================
	inline double GetXSpeed() const { return xSpeed; }
	inline double GetYSpeed() const { return ySpeed; }
	inline double GetXAccel() const { return xAccel; }
	inline double GetYAccel() const { return yAccel; }
	inline double GetSpeed() const { return sqrt(xSpeed * xSpeed + ySpeed * ySpeed); }
	inline double GetLastDirecChange() const { return lastDirecChange; }

    // =======================================================================
    //                            Accessors: setters
    // =======================================================================
	inline void ResetAccel() { xAccel = 0; yAccel = 0; }

    // =======================================================================
    //                                Operators
    // =======================================================================

    // =======================================================================
    //                              Public Methods
    // =======================================================================
	virtual void Update(double deltaT);
	virtual void ApplyForce(double xVal, double yVal);
	virtual void ForceNormSpeed(double speed);

    // =======================================================================
    //                             Public Attributes
    // =======================================================================





  protected :
    // =======================================================================
    //                              Protected Methods
    // =======================================================================

    // =======================================================================
    //                             Protected Attributes
    // =======================================================================
	double xSpeed;
	double ySpeed;
	double xAccel;
	double yAccel;

	double lastDirecChange;

	double mass;
};

#endif // __MOVINGOBJECT_H__

