//****************************************************************************
//
//
//
//****************************************************************************


 
 
// ===========================================================================
//                                   Libraries
// ===========================================================================
#include <algorithm>


// ===========================================================================
//                                 Project Files
// ===========================================================================
#include "MovingObject.h"
#include "Environment.h"



//############################################################################
//                                                                           #
//                           Class MovingObject                              #
//                                                                           #
//############################################################################

// ===========================================================================
//                         Definition of static attributes
// ===========================================================================

// ===========================================================================
//                                  Constructors
// ===========================================================================
MovingObject::MovingObject(double _x, double _y, const Environment * e,
	double _xs, double _ys) : 
	PointObject::PointObject(_x, _y, e), xSpeed(_xs), ySpeed(_ys), 
	xAccel(0), yAccel(0), lastDirecChange(0), 
	mass(1.0)
{
}

// ===========================================================================
//                                  Destructor
// ===========================================================================
MovingObject::~MovingObject( void )
{
}

// ===========================================================================
//                                 Public Methods
// ===========================================================================
void MovingObject::Update(double deltaT)
{
	x += xSpeed * deltaT;
	y += ySpeed * deltaT;
	if (embedSpace and embedSpace->IsTorSpace())
	{
		if (x >= embedSpace->GetXMax())
			x = x - embedSpace->GetXMax();
		if (x < 0.0)
			x = embedSpace->GetXMax() + x;
		
		if (y >= embedSpace->GetYMax())
			y = y - embedSpace->GetYMax();
		if (y < 0.0)
			y = embedSpace->GetYMax() + y;
	}
	xSpeed += xAccel * deltaT;
	ySpeed += yAccel * deltaT;

	if (fabs(xAccel) > 0.0 and fabs(yAccel) > 0.0)
		lastDirecChange = 0.0;
	else
		lastDirecChange += deltaT;
	// TMP
}

void MovingObject::ApplyForce(double xVal, double yVal)
{
	xAccel += xVal / mass;
	yAccel += yVal / mass;
}

void MovingObject::ForceNormSpeed(double speed)
{
	static double normFact;
	normFact = GetSpeed();
	xSpeed *= speed / normFact;
	ySpeed *= speed / normFact;
}

// ===========================================================================
//                                Protected Methods
// ===========================================================================

// ===========================================================================
//                               Non inline accessors
// ===========================================================================

