//****************************************************************************
//
//
//
//****************************************************************************



#ifndef __ENVIRONMENT_H
#define __ENVIRONMENT_H


// ===========================================================================
//                                  Libraries
// ===========================================================================
#include <vector>

// ===========================================================================
//                                Project Files
// ===========================================================================
#include "bwindow.h"
#include "PointObject.h"


// ===========================================================================
//                              Class declarations
// ===========================================================================

#define DEFAULT_ENV_COLOR 0x50B0D0

class Obstacle;
class Simulation;


class Environment
{
  public :
    
    // =======================================================================
    //                                 Enums
    // =======================================================================
	typedef std::vector<Obstacle *>::const_iterator ObstacleIt;
    
    // =======================================================================
    //                               Constructors
    // =======================================================================
    Environment(Simulation *_s, double _xm = 1.0, double _ym = 1.0, bool _ts = false, 
		unsigned int _bgc = DEFAULT_ENV_COLOR);

    // =======================================================================
    //                                Destructor
    // =======================================================================
    virtual ~Environment( void );

    // =======================================================================
    //                            Accessors: getters
    // =======================================================================
	inline double GetXMax() const { return xMax; }
	inline double GetYMax() const { return yMax; }
	inline bool IsTorSpace() const { return useTorSpace; }

	inline ObstacleIt begin() const { return obstacles.begin(); }
	inline ObstacleIt end() const { return obstacles.end(); }

    // =======================================================================
    //                            Accessors: setters
    // =======================================================================

    // =======================================================================
    //                                Operators
    // =======================================================================

    // =======================================================================
    //                              Public Methods
    // =======================================================================
	virtual void Update(double deltaT);
	virtual void Draw(bwindow *w);
	virtual void GenerateRandomObstacles(unsigned int nbObst, int size, 
		unsigned int color);

	virtual void GenerateClusteredObstacles(unsigned int nbClust, unsigned int nbObst,
		int totSize, int size, unsigned int color);

    // =======================================================================
    //                             Public Attributes
    // =======================================================================





  protected :
    // =======================================================================
    //                              Protected Methods
    // =======================================================================

    // =======================================================================
    //                             Protected Attributes
    // =======================================================================
	Simulation *sim;

	double xMax;
	double yMax;
	bool useTorSpace;

	std::vector<Obstacle *> obstacles;

	unsigned int bgColor;
};

#endif // __TEMPLATE_CLASS_H__

