//****************************************************************************
//
//
//
//****************************************************************************


 
 
// ===========================================================================
//                                   Libraries
// ===========================================================================
#include <stdlib.h>
#include <map>


// ===========================================================================
//                                 Project Files
// ===========================================================================
#include "Environment.h"
#include "Obstacle.h"



//############################################################################
//                                                                           #
//                           Class Environment                               #
//                                                                           #
//############################################################################

// ===========================================================================
//                         Definition of static attributes
// ===========================================================================

// ===========================================================================
//                                  Constructors
// ===========================================================================
Environment::Environment(Simulation *_s, double _xm, double _ym, bool ts, 
	unsigned int _bgc) : sim(_s),
	xMax(_xm), yMax(_ym), useTorSpace(ts), bgColor(_bgc)
{
}

// ===========================================================================
//                                  Destructor
// ===========================================================================
Environment::~Environment( void )
{
	for (unsigned int i = 0 ; i < obstacles.size() ; ++i)
		delete obstacles[i];
}

// ===========================================================================
//                                 Public Methods
// ===========================================================================
void Environment::Update(double deltaT)
{
}

void Environment::Draw(bwindow *w)
{
	w->draw_fsquare(0, 0, w->get_width(), w->get_height(), bgColor);
	for (unsigned int i = 0 ; i < obstacles.size() ; ++i)
		obstacles[i]->Draw(w);
}

void Environment::GenerateRandomObstacles(unsigned int nbObst, int size, unsigned int color)
{
	for (unsigned int i = 0 ; i < nbObst ; ++i)
		obstacles.push_back(new Obstacle((double)rand() / RAND_MAX * xMax, 
			(double)rand() / RAND_MAX * yMax, this, size, color));
}

void Environment::GenerateClusteredObstacles(unsigned int nbClust, unsigned int nbObst,
	int totSize, int size, unsigned int color)
{
	double tmpX, tmpY, tmpX2, tmpY2;
	tmpX2 = -1;
	tmpY2 = -1;
	for (unsigned int i = 0 ; i < nbClust ; ++i)
	{
		tmpX = (double)rand() / RAND_MAX * xMax;
		tmpY = (double)rand() / RAND_MAX * yMax;
		for (unsigned int j = 0 ; j < nbObst ; ++j)
		{
			do
				tmpX2 = tmpX + (0.5 - 1.0*((double)rand() / RAND_MAX)) * totSize;
			while ((tmpX2 <= 0) or (tmpX2 >= xMax));
			do
				tmpY2 = tmpY + (0.5 - 1.0*((double)rand() / RAND_MAX)) * totSize;
			while ((tmpY2 <= 0) or (tmpY2 >= yMax));
			obstacles.push_back(new Obstacle(tmpX2, tmpY2, this, size, color));
		}
	}
}

// ===========================================================================
//                                Protected Methods
// ===========================================================================

// ===========================================================================
//                               Non inline accessors
// ===========================================================================

