//****************************************************************************
//
//
//
//****************************************************************************


 
 
// ===========================================================================
//                                   Libraries
// ===========================================================================



// ===========================================================================
//                                 Project Files
// ===========================================================================
#include "ClusterToPop.h"
#include "Population.h"
#include "Simulation.h"


//############################################################################
//                                                                           #
//                           Class ClusterToPop                              #
//                                                                           #
//############################################################################

// ===========================================================================
//                         Definition of static attributes
// ===========================================================================

// ===========================================================================
//                                  Constructors
// ===========================================================================
ClusterToPop::ClusterToPop(double _str, double _rad) : str(_str), radius(_rad)
{
}

// ===========================================================================
//                                  Destructor
// ===========================================================================
ClusterToPop::~ClusterToPop( void )
{
}

// ===========================================================================
//                                 Public Methods
// ===========================================================================
void ClusterToPop::ApplyBehavior(Boid * boid)
{
	static double tmpX;
	static double tmpY;
	static double nbNeighbs;
	static PointObject tmpVect;

	// TODO Optimize
	tmpX = 0;
	tmpY = 0;
	nbNeighbs = 0;
	const Population *pop = boid->GetPop();
	// For each potential neighbor
	for (Population::BoidIt it = pop->begin() ; it != pop->end() ; ++it)
		if ((*it != boid) and ((*it)->DistTo(*boid) <= radius)) // if it is close enough
		{
			++nbNeighbs;
			tmpVect = boid->VectTo(**it);
			tmpX += tmpVect.GetX();
			tmpY += tmpVect.GetY();
			/*
			tmpX += (*it)->GetX();
			tmpY += (*it)->GetY();
			*/
		}

	if (nbNeighbs > 0)
	{
		//tmpVect = boid->VectTo(PointObject(tmpX / nbNeighbs, tmpY / nbNeighbs));
		/*
		tmpX = -str * tmpVect.GetX();
		tmpY = -str * tmpVect.GetY();
		*/
		tmpX = str * (tmpX / nbNeighbs);// - boid->GetX());
		tmpY = str * (tmpY / nbNeighbs);// - boid->GetY());
	}

	boid->ApplyForce(tmpX, tmpY);
}

// ===========================================================================
//                                Protected Methods
// ===========================================================================

// ===========================================================================
//                               Non inline accessors
// ===========================================================================

