//****************************************************************************
//
//
//
//****************************************************************************



#ifndef __BOID_H__
#define __BOID_H__


// ===========================================================================
//                                  Libraries
// ===========================================================================
#include <vector>
#include <map>

// ===========================================================================
//                                Project Files
// ===========================================================================
#include "MovingObject.h"
#include "bwindow.h"
#include "Behavior.h"



// ===========================================================================
//                              Class declarations
// ===========================================================================

// Forward declarations
class Population;


class Boid : public MovingObject
{
  public :
    
    // =======================================================================
    //                                 Enums
    // =======================================================================
    
    // =======================================================================
    //                               Constructors
    // =======================================================================
    Boid(Population *_p);

    // =======================================================================
    //                                Destructor
    // =======================================================================
    virtual ~Boid( void );

    // =======================================================================
    //                            Accessors: getters
    // =======================================================================
	inline const Population * GetPop() const { return pop; }
	inline double GetSize() const { return bSize; }

    // =======================================================================
    //                            Accessors: setters
    // =======================================================================
	inline void SetSize(int size) { bSize = size; }
	inline void SetColor(unsigned int color) { bColor = color; }

    // =======================================================================
    //                                Operators
    // =======================================================================

    // =======================================================================
    //                              Public Methods
    // =======================================================================
	virtual void Update(double deltaT);
	virtual void Draw(bwindow *w);
	virtual void AddBehavior(Behavior *b, bool free);
	virtual void FreezeForTime(double _ft);

	virtual void ToggleTrace();

    // =======================================================================
    //                             Public Attributes
    // =======================================================================





  protected :
    // =======================================================================
    //                              Protected Methods
    // =======================================================================

    // =======================================================================
    //                             Protected Attributes
    // =======================================================================
	Population *pop;
	double minSpeed;
	double maxSpeed;
	double freezeTime;

	int bSize;
	int bDirLenF;
	unsigned int bColor;

	std::vector<std::pair<Behavior *, bool> > behavs;

	bool trace;
	std::vector<PointObject> trajec;
};

#endif // __BOID_H__

