//****************************************************************************
//
//
//
//****************************************************************************

#define DEFAULT_BOID_SIZE 10
#define DEFAULT_BOID_DIR_LEN_FACT 1.5
#define DEFAULT_BOID_DIR_COLOR 0x000000

#define DEFAULT_BOID_SPEED 200

#define DEFAULT_BOID_MIN_SPEED 100
#define DEFAULT_BOID_MAX_SPEED 400
 
// ===========================================================================
//                                   Libraries
// ===========================================================================
#include <stdlib.h>
#include <math.h>
#include <algorithm>

//TEMP
#include <iostream>


// ===========================================================================
//                                 Project Files
// ===========================================================================
#include "Boid.h"
#include "Population.h"
#include "Simulation.h"



//############################################################################
//                                                                           #
//                           Class Boid                                      #
//                                                                           #
//############################################################################

// ===========================================================================
//                         Definition of static attributes
// ===========================================================================

// ===========================================================================
//                                  Constructors
// ===========================================================================
Boid::Boid(Population *_p) : MovingObject::MovingObject(0, 0, _p->GetSim()->GetEnv()), 
	pop(_p), minSpeed(DEFAULT_BOID_MIN_SPEED), 
	maxSpeed(DEFAULT_BOID_MAX_SPEED), freezeTime(0), 
	bSize(DEFAULT_BOID_SIZE), bDirLenF(DEFAULT_BOID_DIR_LEN_FACT), bColor(rand() % 0xFFFFFF),
	trace(false)
{
	x = ((double)rand() / RAND_MAX) * pop->GetSim()->GetEnv()->GetXMax();
	y = ((double)rand() / RAND_MAX) * pop->GetSim()->GetEnv()->GetYMax();
	xSpeed = ((double)rand() / RAND_MAX);
	ySpeed = ((double)rand() / RAND_MAX);
	ForceNormSpeed(DEFAULT_BOID_SPEED);
}

// ===========================================================================
//                                  Destructor
// ===========================================================================
Boid::~Boid( void )
{
	for (unsigned int i = 0 ; i < behavs.size() ; ++i)
		if (behavs[i].second)
			delete behavs[i].first;
}

// ===========================================================================
//                                 Public Methods
// ===========================================================================
void Boid::Update(double deltaT)
{
	ResetAccel();
	if (freezeTime > 0.0)
		freezeTime -= deltaT;
	else
	{
		for (unsigned int i = 0 ; i < behavs.size() ; ++i)
			behavs[i].first->ApplyBehavior(this);
		MovingObject::Update(deltaT);
		if (GetSpeed() < minSpeed)
			MovingObject::ForceNormSpeed(minSpeed);
		else if (GetSpeed() > maxSpeed)
			MovingObject::ForceNormSpeed(maxSpeed);

		// Update trajectory
		if (trace)
			trajec.push_back(PointObject(x, y));
	}
}

void Boid::Draw(bwindow *w)
{
	static int tmpX;
	static int tmpY;
	static double speedNorm;
	static int dirX;
	static int dirY;
	static double Xfact;
	static double Yfact;
	static double Xmax;
	static double Ymax;

	Xmax = pop->GetSim()->GetEnv()->GetXMax();
	Ymax = pop->GetSim()->GetEnv()->GetYMax();

	Xfact = (double)w->get_width() / Xmax;
	Yfact = (double)w->get_height() / Ymax;

	tmpX = x * Xfact;
	tmpY = y * Yfact;
	speedNorm = sqrt(xSpeed * xSpeed + ySpeed * ySpeed);
	dirX = bDirLenF * bSize * (xSpeed / speedNorm);
	dirY = bDirLenF * bSize * (ySpeed / speedNorm);

	//std::cout << x << " // " << y << std::endl;
	//std::cout << tmpX << " // " << tmpY << std::endl;

	// Display trajectory if needed
	if (trace)
		for (unsigned int i = 1 ; i < trajec.size() ; ++i)
			if (fabs(trajec[i-1].GetX() - trajec[i].GetX()) < Xmax / 2.0 and 
					fabs(trajec[i-1].GetY() - trajec[i].GetY()) < Ymax / 2.0)
				w->draw_line(Xfact * trajec[i-1].GetX(), Yfact * trajec[i-1].GetY(), 
					Xfact * trajec[i].GetX(), Yfact * trajec[i].GetY(), 
					(bColor & 0xFF0000) * 0.75 + 
					(bColor & 0x00FF00) * 0.75 + 
					(bColor & 0x0000FF) * 0.75);
			

	if (tmpX >= 0 and tmpX <= w->get_width() and tmpY >= 0 and tmpY <= w->get_height())
	{
		w->draw_fsquare(std::max(0, tmpX - bSize / 2), std::max(0, tmpY - bSize / 2),
					   tmpX + bSize / 2, tmpY + bSize / 2,
					   bColor);
		w->draw_line(tmpX, tmpY, tmpX + dirX, tmpY + dirY, DEFAULT_BOID_DIR_COLOR);
	}

	for (unsigned int i = 0 ; i < behavs.size() ; ++i)
		behavs[i].first->Draw(this, w);
}

void Boid::AddBehavior(Behavior *b, bool free)
{
	behavs.push_back(std::make_pair(b, free));
}

void Boid::FreezeForTime(double _ft)
{
	freezeTime = _ft;
}

void Boid::ToggleTrace()
{
	trace = not trace;
	if (not trace)
		trajec.clear();
}

// ===========================================================================
//                                Protected Methods
// ===========================================================================

// ===========================================================================
//                               Non inline accessors
// ===========================================================================

