//****************************************************************************
//
//
//
//****************************************************************************


 
 
// ===========================================================================
//                                   Libraries
// ===========================================================================



// ===========================================================================
//                                 Project Files
// ===========================================================================
#include "AvoidPredator.h"
#include "Population.h"



//############################################################################
//                                                                           #
//                           Class AvoidPredator                             #
//                                                                           #
//############################################################################

// ===========================================================================
//                         Definition of static attributes
// ===========================================================================

// ===========================================================================
//                                  Constructors
// ===========================================================================
AvoidPredator::AvoidPredator(double _str) : str(_str)
{
}

// ===========================================================================
//                                  Destructor
// ===========================================================================
AvoidPredator::~AvoidPredator( void )
{
}

// ===========================================================================
//                                 Public Methods
// ===========================================================================
void AvoidPredator::ApplyBehavior(Boid * boid)
{
	static double tmpX;
	static double tmpY;
	static double normVal;
	static PointObject tmpVect;
	tmpX = 0;
	tmpY = 0;
	const std::vector<const Population *> & pred = boid->GetPop()->GetPredators();
	// For each potential neighbor
	for (unsigned int i = 0 ; i < pred.size() ; ++i)
		for (Population::BoidIt it = pred[i]->begin() ; it != pred[i]->end() ; ++it)
		{
			tmpVect = boid->VectTo(**it);
			
			tmpX -= tmpVect.GetX() / pow(tmpVect.GetNorm(), 3);
			tmpY -= tmpVect.GetY() / pow(tmpVect.GetNorm(), 3);
		/*
			tmpX += boid->GetX() - (*it)->GetX();
			tmpX += boid->GetY() - (*it)->GetY();
		*/
		}
	
	normVal = sqrt(tmpX * tmpX + tmpY * tmpY);
	if (normVal > 0)
	{
		tmpX *= str / normVal;
		tmpY *= str / normVal;
	}
	
	boid->ApplyForce(tmpX, tmpY);
}

// ===========================================================================
//                                Protected Methods
// ===========================================================================

// ===========================================================================
//                               Non inline accessors
// ===========================================================================

