//****************************************************************************
//
//
//
//****************************************************************************


 
 
// ===========================================================================
//                                   Libraries
// ===========================================================================



// ===========================================================================
//                                 Project Files
// ===========================================================================
#include "AvoidOthers.h"
#include "Population.h"



//############################################################################
//                                                                           #
//                           Class AvoidOthers                               #
//                                                                           #
//############################################################################

// ===========================================================================
//                         Definition of static attributes
// ===========================================================================

// ===========================================================================
//                                  Constructors
// ===========================================================================
AvoidOthers::AvoidOthers(double _str, double _rad) : str(_str), radius(_rad)
{
}

// ===========================================================================
//                                  Destructor
// ===========================================================================
AvoidOthers::~AvoidOthers( void )
{
}

// ===========================================================================
//                                 Public Methods
// ===========================================================================
void AvoidOthers::ApplyBehavior(Boid * boid)
{
	static double tmpX;
	static double tmpY;
	static double nbNeighbs;
	static PointObject tmpVect;

	// TODO Optimize
	tmpX = 0;
	tmpY = 0;
	nbNeighbs = 0;
	const Population *pop = boid->GetPop();
	// For each potential neighbor
	for (Population::BoidIt it = pop->begin() ; it != pop->end() ; ++it)
		if ((*it != boid) and ((*it)->DistTo(*boid) <= radius)) // if it is close enough
		{
			++nbNeighbs;
			tmpVect = boid->VectTo(**it);
			tmpX -= tmpVect.GetX();
			tmpY -= tmpVect.GetY();
			/*
			tmpX -= (*it)->GetX() - boid->GetX();
			tmpY -= (*it)->GetY() - boid->GetY();
			*/
		}

	if (nbNeighbs > 0)
	{
		tmpX *= str / nbNeighbs;
		tmpY *= str / nbNeighbs;
	}

	boid->ApplyForce(tmpX, tmpY);
}

// ===========================================================================
//                                Protected Methods
// ===========================================================================

// ===========================================================================
//                               Non inline accessors
// ===========================================================================

