//****************************************************************************
//
//
//
//****************************************************************************


 
 
// ===========================================================================
//                                   Libraries
// ===========================================================================



// ===========================================================================
//                                 Project Files
// ===========================================================================
#include "AvoidObstacles.h"
#include "Environment.h"
#include "Obstacle.h"
#include "Boid.h"


//############################################################################
//                                                                           #
//                           Class AvoidObstacles                            #
//                                                                           #
//############################################################################

// ===========================================================================
//                         Definition of static attributes
// ===========================================================================

// ===========================================================================
//                                  Constructors
// ===========================================================================
AvoidObstacles::AvoidObstacles(double _str, double _rad) : str(_str), radius(_rad)
{
}

// ===========================================================================
//                                  Destructor
// ===========================================================================
AvoidObstacles::~AvoidObstacles( void )
{
}

// ===========================================================================
//                                 Public Methods
// ===========================================================================
void AvoidObstacles::ApplyBehavior(Boid * boid)
{
	static double tmpX;
	static double tmpY;
	static double nbNeighbs;
	static PointObject tmpVect;

	// TODO Optimize
	tmpX = 0;
	tmpY = 0;
	nbNeighbs = 0;
	const Environment *env = boid->GetEmbedSpace();
	// For each potential neighbor
	for (Environment::ObstacleIt it = env->begin() ; it != env->end() ; ++it)
		if ((*it)->DistTo(*boid) <= (radius + (*it)->GetSize())) // if it is close enough
		{
			++nbNeighbs;
			tmpVect = boid->VectTo(**it);
			tmpX -= tmpVect.GetX();
			tmpY -= tmpVect.GetY();
		}

	if (nbNeighbs > 0)
	{
		tmpX *= str / nbNeighbs;
		tmpY *= str / nbNeighbs;
	}

	boid->ApplyForce(tmpX, tmpY);
}

// ===========================================================================
//                                Protected Methods
// ===========================================================================

// ===========================================================================
//                               Non inline accessors
// ===========================================================================

