//****************************************************************************
//
//
//
//****************************************************************************


 
 
// ===========================================================================
//                                   Libraries
// ===========================================================================



// ===========================================================================
//                                 Project Files
// ===========================================================================
#include "AvoidBorders.h"
#include "Simulation.h"
#include "Boid.h"


//############################################################################
//                                                                           #
//                           Class AvoidBorders                              #
//                                                                           #
//############################################################################

// ===========================================================================
//                         Definition of static attributes
// ===========================================================================

// ===========================================================================
//                                  Constructors
// ===========================================================================
AvoidBorders::AvoidBorders(double _str, double _dist) : str(_str), dist(_dist)
{
}

// ===========================================================================
//                                  Destructor
// ===========================================================================
AvoidBorders::~AvoidBorders( void )
{
}

// ===========================================================================
//                                 Public Methods
// ===========================================================================
void AvoidBorders::ApplyBehavior(Boid * boid)
{
	static double tmpX;
	static double tmpY;
	static double nbNeighbs;

	const Environment *env = boid->GetPop()->GetSim()->GetEnv();

	// TODO Optimize
	tmpX = 0;
	tmpY = 0;
	if (boid->GetX() <= dist)
		tmpX = str * (dist - boid->GetX());
	else if (boid->GetX() >= (env->GetXMax() - dist))
		tmpX = - str * (boid->GetX() - (env->GetXMax() - dist));

	if (boid->GetY() <= dist)
		tmpY = str * (dist - boid->GetY());
	else if (boid->GetY() >= (env->GetYMax() - dist))
		tmpY = - str * (boid->GetY() - (env->GetYMax() - dist));

	boid->ApplyForce(tmpX, tmpY);
}

// ===========================================================================
//                                Protected Methods
// ===========================================================================

// ===========================================================================
//                               Non inline accessors
// ===========================================================================

