//****************************************************************************
//
//
//
//****************************************************************************


 
 
// ===========================================================================
//                                   Libraries
// ===========================================================================



// ===========================================================================
//                                 Project Files
// ===========================================================================
#include "Alignement.h"
#include "Population.h"



//############################################################################
//                                                                           #
//                           Class Alignement                                #
//                                                                           #
//############################################################################

// ===========================================================================
//                         Definition of static attributes
// ===========================================================================

// ===========================================================================
//                                  Constructors
// ===========================================================================
Alignement::Alignement(double _str, double _rad) : str(_str), radius(_rad)
{
}

// ===========================================================================
//                                  Destructor
// ===========================================================================
Alignement::~Alignement( void )
{
}

// ===========================================================================
//                                 Public Methods
// ===========================================================================
void Alignement::ApplyBehavior(Boid * boid)
{
	static double tmpX;
	static double tmpY;
	static double nbNeighbs;

	// TODO Optimize
	tmpX = 0;
	tmpY = 0;
	nbNeighbs = 0;
	const Population *pop = boid->GetPop();
	// For each potential neighbor
	for (Population::BoidIt it = pop->begin() ; it != pop->end() ; ++it)
		if ((*it != boid) and ((*it)->DistTo(*boid) <= radius)) // if it is close enough
		{
			++nbNeighbs;
			tmpX += (*it)->GetXSpeed() - boid->GetXSpeed();
			tmpY += (*it)->GetYSpeed() - boid->GetYSpeed();
		}

	if (nbNeighbs > 0)
	{
		tmpX *= str / nbNeighbs;
		tmpY *= str / nbNeighbs;
	}

	boid->ApplyForce(tmpX, tmpY);
}

// ===========================================================================
//                                Protected Methods
// ===========================================================================

// ===========================================================================
//                               Non inline accessors
// ===========================================================================

