import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class JeuDeLaVie {

// L'univers torique n'est pas demandé dans le sujet, c'est un bonus.
public static boolean USETORIC = true;

public static void main(String[] args) {
	int lignes = 40;
	int cols = 150;
	int[][] univers = new int[lignes][cols];
	final int NBMAXGENERATIONS = 10000;

	// Cette version permet de charger un fichier en donnant son nom quand
	// on lance le programme en console :
	//      java JeuDeLaVie NomDuFichier.txt
	if (args.length > 0) {
		LoadFromFile(univers, args[0]);
	} else {
		//RemplirUnivers(univers, lignes / 2, cols / 2);
		GenerationAleatoire(univers, 0.6);
	}

	boolean vide = false;

	AfficherUnivers(univers);
	for (int i = 0 ; i < NBMAXGENERATIONS && !vide ; i++) {
		EvolutionParam(univers);
		// La première version de l'affichage est remplacée par la version optimisée.
		//AfficherUnivers(univers);
		AfficherOptim(univers);
		vide = UniversVide(univers);

		// On fait une pause pendant 40 ms, ce code n'est pas au programme de la première année.
		try {
		   Thread.currentThread().sleep(40);
		} catch (InterruptedException e) {
		   e.printStackTrace();
        }
	}
}

public static void RemplirUnivers(int[][] univ, int ln, int col) {
	for (int i = 1 ; i < univ.length - 1 ; i++) {
		univ[i][col] = 1;
	}
	for (int i = 1 ; i < univ[ln].length - 1 ; i++) {
		univ[ln][i] = 1;
	}
}

public static void GenerationAleatoire(int[][] univ, double densite) {
	for (int i = 1 ; i < univ.length - 1 ; i++) {
		for (int j = 1 ; j < univ[i].length - 1 ; j++) {
			if (Math.random() < densite) {
				univ[i][j] = 0;
			} else {
				univ[i][j] = 1;
			}
		}
	}
}

public static void AfficherUnivers(int[][] univ) {
	for (int i = 0 ; i < univ.length ; i++) {
		for (int j = 0 ; j < univ[i].length ; j++) {
			if (univ[i][j] == 1) {
				System.out.print("@");
			} else {
				System.out.print(".");
			}
		}
		System.out.println();
	}
	System.out.println();
}

public static void AfficherOptim(int[][] univ) {
	String tmp = "";
	for (int i = 0 ; i < univ.length ; i++) {
		for (int j = 0 ; j < univ[i].length ; j++) {
			if (univ[i][j] == 1) {
				tmp += "@";
			} else {
				tmp += " ";
			}
		}
		tmp += "\n";
	}
	System.out.println(tmp);
}

/*
// Cette version commentée de NbrCellulesVoisines correspond à ce qui est demandé dans le sujet.
public static int NbrCellulesVoisines(int[][] univ, int ln, int col) {
	int tmp = 0;
	for (int i = ln - 1 ; i <= ln + 1 ; i++) {
		for (int j = col - 1 ; j <= col + 1 ; j++) {
			if ((i != ln || j != col) && univ[i][j] > 0) {
				tmp++;
			}
		}
	}
	return tmp;
}
*/

// Cette version de NbrCellulesVoisines prend en compte le fait que l'univers est torique.
public static int NbrCellulesVoisines(int[][] univ, int ln, int col) {
	int tmp = 0;
	for (int i = ln - 1 ; i <= ln + 1 ; i++) {
		for (int j = col - 1 ; j <= col + 1 ; j++) {
			if ((i != ln || j != col) && univ[(i+univ.length)%univ.length][(j+univ[0].length)%univ[0].length] > 0) {
				tmp++;
			}
		}
	}
	return tmp;
}

public static int[][] EvolutionRetour(int[][] univ) {
	int[][] newUniv = new int[univ.length][univ[0].length];
	// Les deux boucles for commentées doivent être utilisées lorsque l'univers n'est pas torique.
	//for (int i = 1 ; i < univ.length - 1 ; i++) {
	for (int i = 0 ; i < univ.length ; i++) {
		//for (int j = 1 ; j < univ[i].length - 1 ; j++) {
		for (int j = 0 ; j < univ[i].length ; j++) {
			int nbVois = NbrCellulesVoisines(univ, i, j);
			if (univ[i][j] == 0) {
				if (nbVois == 3) {
					newUniv[i][j] = 1;
				}
			} else if (nbVois < 4 && nbVois > 1) {
				newUniv[i][j] = 1;
			} else {
				newUniv[i][j] = 0;
			}

			// Uniquement utile si l'univers n'est pas torique.
			if (!USETORIC && (i == 0 || i == univ.length - 1 || j == 0 || j == univ[0].length - 1))
				univ[i][j] = 0;
		}
	}
	return newUniv;
}

public static void EvolutionParam(int[][] univ) {
	int[][] tmp = EvolutionRetour(univ);
	for (int i = 0 ; i < univ.length ; i++) {
		for (int j = 0 ; j < univ[i].length ; j++) {
			univ[i][j] = tmp[i][j];
		}
	}
}

public static boolean UniversVide(int[][] univ) {
	boolean vide = true;
	for (int i = 0 ; i < univ.length && vide ; i++) {
		for (int j = 0 ; j < univ[i].length && vide ; j++) {
			vide = (univ[i][j] == 0);
		}
	}
	return vide;
}

// Cette méthode n'est pas demandée dans le sujet, elle sert à charger un univers depuis un fichier.
public static void LoadFromFile(int[][] univers, String path) {
	File file = new File(path);
    FileInputStream fis = null;
    BufferedInputStream bis = null;
    DataInputStream dis = null;

	try {
		fis = new FileInputStream(file);
		bis = new BufferedInputStream(fis);
		dis = new DataInputStream(bis);

		int currLine = 0;
		while (dis.available() != 0) {
			currLine++;
			String tmp = dis.readLine();
			for (int i = 1 ; i < univers[currLine].length - 1 && i-1 < tmp.length() ; i++){
				if (tmp.charAt(i-1) == '@')
					univers[currLine][i] = 1;
				else
					univers[currLine][i] = 0;
			}

		}
		fis.close();
		bis.close();
		dis.close();
	} catch (FileNotFoundException e) {
		e.printStackTrace();
	} catch (IOException e) {
		e.printStackTrace();
	}
}

};
